<?php

if (!defined('ABSPATH')) {
    exit;
}

function giftcity_wc_is_woocommerce_active(): bool
{
    return class_exists('WooCommerce');
}

function giftcity_wc_get_settings(): array
{
    $defaults = [
        'api_base'        => 'https://gift30t.com/api/v1',
        'api_key'         => '',
        'default_markup'  => 10,
        'sync_interval'   => 'hourly',
        'auto_sync'       => 'yes',
    ];

    $options = get_option('giftcity_wc_settings', []);

    return wp_parse_args(is_array($options) ? $options : [], $defaults);
}

function giftcity_wc_get_option(string $key, $default = '')
{
    $settings = giftcity_wc_get_settings();
    return isset($settings[$key]) ? $settings[$key] : $default;
}

function giftcity_wc_log(string $message, string $level = 'info'): void
{
    if (function_exists('wc_get_logger')) {
        $logger = wc_get_logger();
        $logger->log($level, $message, ['source' => 'giftcity-wc']);
        return;
    }

    error_log('[GiftCity WC] ' . $message);
}

function giftcity_wc_format_money($amount): string
{
    $amount = floatval($amount);
    return number_format_i18n($amount, 0) . ' تومان';
}
